from go_to_adjacent_systems import *
import unit
import VS
import universe
import vsrandom
import fg_util
import launch
import Director
import faction_ships


class attack_pod( Director.Mission):
        def __init__( self, creds, flightPath, destNavpointName, numShips, enemyFaction):
            Director.Mission.__init__(self)
            self.you = VS.getPlayer()
            self.creds = creds
            self.flightPath = flightPath
            self.destNavpointName = destNavpointName
            self.destNavpoint = None
            self.numShips = numShips
            self.enemyFaction = enemyFaction
                
            #self.destSysTask = go_to_adjacent_systems( self.you, 0, self.flightPath)
            self.destSysTask = go_to_adjacent_systems( self.you, 0, self.flightPath, '', False)
            self.objGotoDestSys = VS.addObjective( "Go to %s." % self.flightPath[-1][7:])
            self.missionStage = "start"
            self.objGotoDestNavpoint = -1
            self.objRemainingEnemies = -1
            
            self.enemyGreetTime = 10000000
            self.enemyShips = []
            self.waves = self.prepareWaves()
            self.nextWaveLaunchTime = 10000000
            self.spawnRange = min( 2200, faction_ships.calcRadarRange( self.you))
            self.spawnGalaxyChance = 0
            if (enemyFaction == "pirates") and (numShips > 6):
                self.spawnGalaxyChance = .33
	
        
        def payOffMission( self):
            self.you.addCredits( self.creds)
            VS.terminateMission( 1)


        def prepareWaves( self):
            if self.enemyFaction == "kilrathi":
                shipQuantities = [ 2, 2, 2, 3, 3]
                lastWaveMaxNum = 4
            else:
                shipQuantities = [ 2, 2, 3, 3, 3, 3, 4, 4, 4]
                lastWaveMaxNum = 5
            
            waves = []
            tnumShips = self.numShips
            while tnumShips > 0:
                if tnumShips <= lastWaveMaxNum and vsrandom.random() < .4:
                    nextNum = tnumShips
                else:
                    nextNum = shipQuantities[ vsrandom.randrange( 0, len( shipQuantities)) ]
                tnumShips -= nextNum
                waves.append( fg_util.chooseRandomShips( self.enemyFaction, nextNum))                   # eg: [ [(talon, 2), (talon.retro2, 1)], [ (talon, 3)] ]

            print "PODXXatk waves: " + str( waves)
            return waves
            
        
        def launchNextWave( self):
            if not len( self.waves):
                return
            launchAroundUnit = self.you
            for nextShipType in self.waves[0]:
                for i in range( nextShipType[1]):
                    L = launch.Launch()
                    L.fg = "Shadow"
                    L.faction = self.enemyFaction
                    L.type = nextShipType[0]
                    L.num = 1
                    L.ai = "default"
                    if launchAroundUnit == self.you:
                        if vsrandom.random() < self.spawnGalaxyChance:
                            L.type = "galaxy.pirpar"
                            self.spawnGalaxyChance = 0
                        L.minradius = self.spawnRange - 200
                        L.maxradius = self.spawnRange - 100
                    else:
                        L.minradius = 200
                        L.maxradius = 500
                    enemy = L.launch( launchAroundUnit)
                    enemy.SetTarget( self.you)
                    enemy.setFgDirective( "A.")
                    self.enemyShips.append( enemy)
                    #print "PODXXatk next enemy: " + enemy.getName()
                    if launchAroundUnit == self.you:
                        launchAroundUnit = enemy
            del self.waves[0]
            
        
	def updateRemainingEnemiesObjective( self):
            if self.objRemainingEnemies < 0:
                self.objRemainingEnemies = VS.addObjective( "")
                
            numEnemies = len( self.enemyShips)
            if numEnemies > 0:
                #objText = "Eliminate enemies (" + str( numEnemies) + ")"
                objText = "Destroy " + self.enemyFaction.capitalize() + " ships (" + str( numEnemies) + ")"
                VS.setCompleteness( self.objRemainingEnemies, -1.0)
            else:
                #objText = "Seek around " + self.destNavpointName
                objText = "Defend " + self.destNavpointName
                VS.setCompleteness( self.objRemainingEnemies, -.5)
                
            VS.setObjective( self.objRemainingEnemies, objText)
                
        
        def calcNextWaveLaunchTime( self):
            if not len( self.waves):
                return 10000000
            minTime = 60
            maxTime = 120
            if self.enemyFaction == "kilrathi":
                minTime = 90
                maxTime = 150
            delay = vsrandom.randrange( minTime, maxTime)
            print "PODXXatk launch delay: " + str( delay)
            return VS.GetGameTime() + delay
            
        
        def untrackDeadEnemies( self):
            validEnemies = []
            for nextEnemy in self.enemyShips:
                if not nextEnemy.isNull():
                    validEnemies.append( nextEnemy)
            self.enemyShips = validEnemies
        
        
        def Execute( self):
            if not self.you:
                VS.terminateMission( 0)
                return
            if VS.GetGameTime() >= self.enemyGreetTime:
                self.enemyGreetTime = 10000000
                universe.greet( universe.getRandomGreeting( self.enemyFaction), self.enemyShips[0], self.you)
            
            if self.missionStage == "start":
                if self.destSysTask.Execute() and not self.destNavpoint:
                    VS.setCompleteness( self.objGotoDestSys, 1.0)
                    self.destNavpoint = universe.findUnit( self.destNavpointName)
                    self.objGotoDestNavpoint = VS.addObjective( "Go to " + self.destNavpointName)
                    self.missionStage = "arrivedToSystem"
                return
            
            if self.missionStage == "arrivedToSystem":
                if self.you.getDistance( self.destNavpoint) < 2000:
                    self.launchNextWave()
                    self.nextWaveLaunchTime = self.calcNextWaveLaunchTime()
                    self.enemyGreetTime = VS.GetGameTime() + 6
                    VS.setCompleteness( self.objGotoDestNavpoint, 1.0)
                    self.missionStage = "fighting"
                return
            
            if self.missionStage == "fighting":
                self.untrackDeadEnemies()
                
                if VS.GetGameTime() >= self.nextWaveLaunchTime and self.you.getDistance( self.destNavpoint) < 2000:
                    self.launchNextWave()
                    self.nextWaveLaunchTime = self.calcNextWaveLaunchTime()
                if not len( self.enemyShips):
                    if not len( self.waves):
                        self.payOffMission()
                        return
                    elif VS.GetGameTime() - self.nextWaveLaunchTime > 30:
                        self.nextWaveLaunchTime = VS.GetGameTime() + 30
            
                self.updateRemainingEnemiesObjective()


            return   # End of Execute()