import patrol
import universe
import VS

class patrol_pod(patrol.patrol):
	def __init__( self, numsystemsaway, num_points, distance, creds, jumps, guildRewardMod = 1.0, donevar='', patrolPointsNames = []):
		patrol.patrol.__init__(self,numsystemsaway,num_points,distance,creds,jumps,donevar,patrolPointsNames)
                self.nearbyEnemyShips = []
                self.credBonusEarned = 0
                self.credBonusObjective = 0
                self.nextEnemyScanTime = 0
                self.patrolPointsInitialList = []
                self.patrolPointAreaRange = 5000
                self.enemyTrackingRange = 1200
                self.isScannedAllPatrolPoints = False
                self.guildRewardMod = guildRewardMod
                self.patrolSystemName = jumps[-1]
                
                
	def isInPatrolArea( self):
                if self.you.getUnitSystemFile() <> self.patrolSystemName:
                    return False
                for nextPP in self.patrolPointsInitialList:
                    if ( self.you.getDistance( nextPP) < self.patrolPointAreaRange ):
                        return True
                return False
        
        def GeneratePatrolList( self):
                self.credBonusObjective = VS.addObjective( "Extra payment: %d" % self.credBonusEarned)
                VS.setCompleteness( self.credBonusObjective, -.4)
                patrol.patrol.GeneratePatrolList( self)
                # saving patrol points for later use
                self.patrolPointsInitialList = list( self.patrolpoints)
        
        def calcShipValue( self, shipType, faction):
                value = 500
                if ( faction == "retro" ):
                    value = 700
                elif ( faction == "pirates" ):
                    value = 800
                elif ( faction == "kilrathi" and shipType == "dralthi" ):
                    value = 1500
                elif ( faction == "kilrathi" and shipType == "gothri" ):
                    value = 2500
                return value * self.guildRewardMod
                
	def SuccessMission( self):
                self.isScannedAllPatrolPoints = True

	def missionSuccessAndNoEnemiesNear( self):
                self.cred += self.credBonusEarned
                patrol.patrol.SuccessMission( self)
        
        def DeletePatrolPoint(self,num,nam):
		patrol.patrol.DeletePatrolPoint(self,num,nam)
		
	def isOnTrackList( self, unit):
                for nextEnemy in self.nearbyEnemyShips:
                    if ( unit == nextEnemy[0] ):
                        return True
                return False
        
        def untrackDeadOrFarawayEnemies( self):
                validEnemies = []
                for nextEnemy in self.nearbyEnemyShips:
                    if ( nextEnemy[0].isNull() ):
                        if ( self.isInPatrolArea() ):
                            self.credBonusEarned += self.calcShipValue( nextEnemy[1], nextEnemy[2])
                            VS.setObjective( self.credBonusObjective, "Extra payment: %d" % self.credBonusEarned)
                            #print "PODXXpatrol destroyed: " + nextEnemy[1] + ", faction: " + nextEnemy[2] + ", credBonus: " + str(self.credBonusEarned)
                    else:
                        #print "PODXXpatrol still alive: " + nextEnemy[1] + ", faction: " + nextEnemy[2] + ", dist: " + str( self.you.getDistance( nextEnemy[0]))
                        if ( self.you.getDistance( nextEnemy[0]) < self.enemyTrackingRange ):
                            validEnemies.append( nextEnemy )
                self.nearbyEnemyShips = validEnemies
        
        def Execute (self):
                if ( len( self.patrolPointsInitialList) and self.nextEnemyScanTime < VS.GetGameTime() ):
                    #print "PODXXpatrol scan next iteration"
                    self.nextEnemyScanTime = VS.GetGameTime() + 3

                    self.untrackDeadOrFarawayEnemies()
                    
                    # scanning for nearby enemies to track
                    unitsList = VS.getUnitList()
                    nextUnit = unitsList.current()
                    while ( unitsList.notDone() and not nextUnit.isNull() ):
                        if ( nextUnit.isStarShip() ):
                            uFaction = nextUnit.getFactionName()
                            uDistance = self.you.getDistance( nextUnit)
                            uName = nextUnit.getFullname()
                            if ( uFaction in ["retro", "pirates", "kilrathi"] ):
                                #print "PODXXpatrol Next unit: " + uName + ", fac: " + uFaction + ", dist: " + str(uDistance)
                                if ( uDistance < self.enemyTrackingRange and not self.isOnTrackList( nextUnit) ):
                                    self.nearbyEnemyShips.append( (nextUnit, uName, uFaction) )
                        unitsList.advanceInsignificant()
                        nextUnit = unitsList.current()
                        
		if ( self.isScannedAllPatrolPoints ):
		    if ( len( self.nearbyEnemyShips) <= 0 ):
                        self.missionSuccessAndNoEnemiesNear()
		else:
		    patrol.patrol.Execute( self)
