:: Wing Commander (FM Towns)
:: Auto-Boot Patch Applier
::
:: Written by Derek Pascarella (ateam)

@echo off

setlocal enabledelayedexpansion

:: Set terminal window size.
mode con:cols=96 lines=39

:: Welcome message
type tools\banner.txt
echo.
echo                 _________________________
echo           __,--^|     Auto-Boot Patch     ^|--,__
echo             '--^|        FM Towns         ^|--'
echo                 `````````````````````````
echo.
echo Initiating patching process...
echo.

:: Define paths.
set "original_folder=redump_original"
set "patched_folder=patched_disc_image_cue_bin"
set "ccd_folder=patched_disc_image_ccd_img_sub"
set "target_file=Wing Commander (Japan) (En,Ja) (Track 01).bin"
set "target_file_iso=Wing Commander (Japan) (En,Ja) (Track 01).iso"
set "cue_file=Wing Commander (Japan) (En,Ja).cue"
set "patch_folder=xdelta"
set "patch_file=Wing Commander (Auto-Boot).xdelta"
set "tools_folder=tools"
set "xdelta_exe=xdelta.exe"

:: Perform sanity check.
echo Performing sanity check...
echo.

if not exist "%original_folder%" (
    echo Error: Folder "%original_folder%" does not exist.
    echo.
    goto End
)

if not exist "%original_folder%\%target_file%" (
    echo Error: File "%target_file%" does not exist in %original_folder%" folder.
    echo.
    goto End
)

if not exist "%tools_folder%" (
    echo Error: Folder "%tool_folder%" does not exist.
    echo.
    goto End
)

if not exist "%tools_folder%\%xdelta_exe%" (
    echo Error: File "%xdelta_exe%" does not exist in %tools_folder%" folder.
    echo.
    goto End
)

if not exist "%patch_folder%\%patch_file%" (
    echo Error: File "%patch_file%" does not exist in %patch_folder%" folder.
    echo.
    goto End
)

:: Clean up old files.
echo Cleaning up old files....
echo.
del /q "%patched_folder%\*" > nul 2>&1
del /q "%ccd_folder%\*" > nul 2>&1

:: Copy original disc image to patched folder.
echo Copying all files from "%original_folder%" to "%patched_folder%"...
echo.

xcopy "%original_folder%\*" "%patched_folder%\" /S /I /Y > nul 2>&1
if errorlevel 1 (
	echo Error: Failed to copy files to "%patched_folder%" folder.
	echo.
	goto End
)

echo Files copied successfully.
echo.

:: Apply XDelta patch.
echo Applying patch...
echo.

"%tools_folder%\%xdelta_exe%" -f -d -s "%original_folder%\%target_file%" "%patch_folder%\%patch_file%" "%patched_folder%\%target_file_iso%" > nul 2>&1
if errorlevel 1 (
	echo Error: Failed to apply the XDelta patch.
	echo.
	goto End
)

echo Patch applied successfully.
echo.

:: Delete original CUE and data track BIN.
del /q "%patched_folder%\%target_file%" > nul 2>&1
del /q "%patched_folder%\%cue_file%" > nul 2>&1

:: Copy modified CUE to patched disc image folder.
copy /Y "%tools_folder%\%cue_file%" "%patched_folder%" > nul 2>&1

:: CUE/BIN completion message.
echo Patched CUE/BIN disc image is located in the "%patched_folder%" folder.
echo.

:: Generate CCD/IMG/SUB formatted disc image.
echo Creating CCD/IMG/SUB version of patched disc image...
echo.

:: Create output folder.
if not exist "%ccd_folder%" (
    mkdir "%ccd_folder%"
)

:: Copy all CUE, BIN, and ISO files to CCD folder.
copy /Y "%patched_folder%\*.cue" "%ccd_folder%" >nul
copy /Y "%patched_folder%\*.bin" "%ccd_folder%" >nul
copy /Y "%patched_folder%\*.iso" "%ccd_folder%" >nul

:: Run cue2ccd.exe on the .cue file inside the target folder.
for %%F in ("%ccd_folder%\*.cue") do (
    pushd "%ccd_folder%"
    "%~dp0%tools_folder%\cue2ccd.exe" "%%~nxF" >nul
    if errorlevel 1 (
        echo ERROR: Failed to generate CCD/IMG/SUB disc image from %%F
        echo Cleaning up temporary files...
        del /Q "*.cue"
        del /Q "*.bin"
        popd
        goto End
    )
    ::del /Q "%%~nxF"
    set "bin_file=%%~nF.bin"
    if exist "!bin_file!" del /Q "!bin_file!"
    popd
)

:: Move generated CCD/IMG/SUB files up one level and clean up.
for /d %%D in ("%ccd_folder%\CCD\*") do (
    move "%%D\*.ccd" "%ccd_folder%" >nul
    move "%%D\*.img" "%ccd_folder%" >nul
    move "%%D\*.sub" "%ccd_folder%" >nul
    rd /s /q "%%D"
)
rd /s /q "%ccd_folder%\CCD"

:: Final clean-up of CUE, BIN, and ISO files.
del /Q "%ccd_folder%\*.cue"
del /Q "%ccd_folder%\*.bin"
del /Q "%ccd_folder%\*.iso"

:: Completion message.
echo Patched CCD/IMG/SUB disc image is located in the "%ccd_folder%" folder.
echo.
echo Patching process completed successfully.
echo.
:End
echo Press any key to close this window...
pause > nul

endlocal